/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbcserver;

import com.mckoi.database.Database;
import com.mckoi.database.jdbcserver.ConnectionPoolServer;
import com.mckoi.database.jdbcserver.ServerConnection;
import com.mckoi.debug.DebugLogger;
import java.io.IOException;
import java.util.ArrayList;

final class SingleThreadedConnectionPoolServer
implements ConnectionPoolServer {
    private static final int PING_BREAK = 45000;
    private static final boolean DISPLAY_STATS = false;
    private Database database;
    private ArrayList pending_connections_list;
    private ServerFarmer farmer;

    SingleThreadedConnectionPoolServer(Database database) {
        this.database = database;
        this.pending_connections_list = new ArrayList();
        this.farmer = new ServerFarmer();
        this.farmer.start();
    }

    public final DebugLogger Debug() {
        return this.database.Debug();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(ServerConnection connection) {
        ArrayList arrayList = this.pending_connections_list;
        synchronized (arrayList) {
            this.pending_connections_list.add(connection);
        }
    }

    public void close() {
        this.farmer.close();
    }

    private final class ServerConnectionState {
        private ServerConnection connection;
        private boolean is_processing_request;
        private boolean is_pending_command;
        private boolean is_ping_client;

        ServerConnectionState(ServerConnection connection) {
            this.connection = connection;
            this.clearInternal();
        }

        public synchronized void setProcessingRequest() {
            this.is_processing_request = true;
        }

        public synchronized void setPendingCommand() {
            this.is_pending_command = true;
        }

        public synchronized void setPingClient() {
            this.is_ping_client = true;
        }

        public synchronized void clearInternal() {
            this.is_processing_request = false;
            this.is_pending_command = false;
            this.is_ping_client = false;
        }

        public synchronized void clearProcessingRequest() {
            this.is_processing_request = false;
        }

        public synchronized ServerConnection getConnection() {
            return this.connection;
        }

        public synchronized boolean isProcessingRequest() {
            return this.is_processing_request;
        }

        public synchronized boolean hasPendingCommand() {
            return this.is_pending_command;
        }

        public synchronized boolean isPingClient() {
            return this.is_ping_client;
        }
    }

    private class ServerFarmer
    extends Thread {
        private ArrayList server_connections_list = new ArrayList();
        private int stat_display = 0;
        private int commands_run = 0;
        private int commands_waited = 0;
        private boolean farmer_closed = false;
        private int poll_wait_time = 3;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void establishPendingConnections() throws IOException {
            ArrayList arrayList = SingleThreadedConnectionPoolServer.this.pending_connections_list;
            synchronized (arrayList) {
                int len = SingleThreadedConnectionPoolServer.this.pending_connections_list.size();
                for (int i = 0; i < len; ++i) {
                    ServerConnection connection = (ServerConnection)SingleThreadedConnectionPoolServer.this.pending_connections_list.remove(0);
                    this.server_connections_list.add(new ServerConnectionState(connection));
                }
            }
        }

        private void checkCurrentConnections() {
            int len = this.server_connections_list.size();
            for (int i = len - 1; i >= 0; --i) {
                ServerConnectionState connection_state = (ServerConnectionState)this.server_connections_list.get(i);
                try {
                    if (connection_state.isProcessingRequest()) continue;
                    ServerConnection connection = connection_state.getConnection();
                    if (!connection_state.hasPendingCommand() && !connection.requestPending()) continue;
                    connection_state.setPendingCommand();
                    connection_state.setProcessingRequest();
                    final ServerConnectionState current_state = connection_state;
                    SingleThreadedConnectionPoolServer.this.database.execute(null, null, new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                try {
                                    current_state.getConnection().processRequest();
                                }
                                catch (IOException e) {
                                    SingleThreadedConnectionPoolServer.this.Debug().writeException(10, e);
                                    Object var3_2 = null;
                                    current_state.clearInternal();
                                }
                                Object var3_1 = null;
                                current_state.clearInternal();
                            }
                            catch (Throwable throwable) {
                                Object var3_3 = null;
                                current_state.clearInternal();
                                throw throwable;
                            }
                        }
                    });
                    continue;
                }
                catch (IOException e) {
                    try {
                        connection_state.getConnection().close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    this.server_connections_list.remove(i);
                    SingleThreadedConnectionPoolServer.this.Debug().write(10, this, "IOException generated while checking connections, removing provider.");
                    SingleThreadedConnectionPoolServer.this.Debug().writeException(10, e);
                }
            }
        }

        private void doPings() {
            int len = this.server_connections_list.size();
            if (len == 0) {
                return;
            }
            int i = (int)(Math.random() * (double)len);
            final ServerConnectionState connection_state = (ServerConnectionState)this.server_connections_list.get(i);
            if (!connection_state.isProcessingRequest()) {
                connection_state.setProcessingRequest();
                SingleThreadedConnectionPoolServer.this.database.execute(null, null, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            try {
                                connection_state.getConnection().ping();
                            }
                            catch (IOException e) {
                                try {
                                    connection_state.getConnection().close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                SingleThreadedConnectionPoolServer.this.Debug().write(30, ServerFarmer.this, "Closed because ping failed.");
                                SingleThreadedConnectionPoolServer.this.Debug().writeException(30, e);
                                Object var4_2 = null;
                                connection_state.clearProcessingRequest();
                            }
                            Object var4_1 = null;
                            connection_state.clearProcessingRequest();
                        }
                        catch (Throwable throwable) {
                            Object var4_3 = null;
                            connection_state.clearProcessingRequest();
                            throw throwable;
                        }
                    }
                });
            }
        }

        private void displayStatistics() {
        }

        public synchronized void close() {
            this.farmer_closed = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int yield_count = 0;
            long do_ping_time = System.currentTimeMillis() + 45000L;
            int ping_count = 200;
            int method_poll_wait_time = this.poll_wait_time;
            SingleThreadedConnectionPoolServer.this.Debug().write(10000, this, "Polling frequency: " + method_poll_wait_time + "ms.");
            while (true) {
                try {
                    while (true) {
                        ServerFarmer current_time2;
                        if (SingleThreadedConnectionPoolServer.this.pending_connections_list.size() > 0) {
                            this.establishPendingConnections();
                        }
                        this.checkCurrentConnections();
                        if (--ping_count <= 0) {
                            ping_count = 2000;
                            long current_time2 = System.currentTimeMillis();
                            if (current_time2 > do_ping_time) {
                                this.doPings();
                                do_ping_time = current_time2 + 45000L;
                            }
                        }
                        if (yield_count <= 0) {
                            current_time2 = this;
                            synchronized (current_time2) {
                                this.wait(method_poll_wait_time);
                                yield_count = 3;
                            }
                        }
                        current_time2 = this;
                        synchronized (current_time2) {
                            if (this.farmer_closed) {
                                return;
                            }
                        }
                        Thread.yield();
                        --yield_count;
                        this.displayStatistics();
                    }
                }
                catch (Throwable e) {
                    SingleThreadedConnectionPoolServer.this.Debug().write(40, this, "Connection Pool Farmer Error");
                    SingleThreadedConnectionPoolServer.this.Debug().writeException(e);
                    ServerFarmer serverFarmer = this;
                    synchronized (serverFarmer) {
                        try {
                            this.wait(2000L);
                        }
                        catch (InterruptedException e2) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

